import { useStores } from "@/store/index";
import { elements } from "@/router";
import { current } from "@/api/demo_api";
import { product } from "@/api/project_api";

import localStorageKey from "@/utils/localStorageKey";
import NotFound from "@/views/404";
import useMyRequest from "@/hooks/useMyRequest";
import { useEffect } from "react";
import { menu } from "@/api/routes_api";
import {
  setFileServerEndPointLocalStorage,
  getFiletokenAccordingToId,
} from "@/views/Project/project";

const useMyRouter = () => {
  const { permissionStore, menuStore, currentProjectStore } = useStores();
  const userInfo = useMyRequest(current);
  const menuInfo = useMyRequest(menu);
  const productInfo = useMyRequest(product);

  useEffect(() => {
    userInfo.run();
    menuInfo.run();
    productInfo.run({
      product: "CADD",
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  useEffect(() => {
    if (userInfo.res && menuInfo.res) {
      localStorage.setItem(
        localStorageKey.USER_INFO,
        JSON.stringify(userInfo.res)
      );

      permissionStore.restAddRoutes();
      for (let item of menuInfo.res.data) {
        for (let route of item.routes) {
          route.element = elements[route.element] || NotFound;
          route.path = `/product/${item.id}${route.path}`;
        }
        permissionStore.setAddRoutes(item.routes);
      }
      menuStore.initMenu(menuInfo.res.data);
      permissionStore.initAllRoutes();
    }

    if (productInfo.res) {
      let list = productInfo.data?.data;
      if (list.length === 0) {
        currentProjectStore.setProjectList([]);
        currentProjectStore.changeProject({});
      } else {
        currentProjectStore.setProjectList(list);
        currentProjectStore.changeProject(list[0]);
        setFileServerEndPointLocalStorage(list[0].zoneId);
        getFiletokenAccordingToId(list[0].id).then((res) => {
          list[0].filetoken = res;
          currentProjectStore.changeProject(list[0]);
        });
      }
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [userInfo.data, menuInfo.data, productInfo.data]);

  return permissionStore.allRoutes;
};

export default useMyRouter;
