/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-02 10:38:01
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-02 13:45:33
 * @FilePath: /bkunyun/src/components/mui/Table.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import * as React from "react";
import MuiTable from "@mui/material/Table";
import TableBody from "@mui/material/TableBody";
import TableCell from "@mui/material/TableCell";
import TableContainer from "@mui/material/TableContainer";
import TableHead from "@mui/material/TableHead";
import TableRow from "@mui/material/TableRow";
import Paper from "@mui/material/Paper";
import { Box } from "@mui/material";

interface IColumns {
  key: string;
  title: string;
  align?: "left" | "center" | "right";
  render?: (value: any, index: number) => void;
}

interface IProps {
  columns: IColumns[];
  dataSource: any;
}

export default function Table(props: IProps) {
  const { columns = [], dataSource = [] } = props;
  return (
    <TableContainer component={Paper}>
      <MuiTable sx={{ minWidth: 650 }} aria-label="simple table">
        <TableHead>
          <TableRow>
            {columns?.map((item: IColumns) => {
              return (
                <TableCell {...item} key={item.key}>
                  {item.title}
                </TableCell>
              );
            })}
          </TableRow>
        </TableHead>
        <TableBody>
          {dataSource.length ? (
            dataSource?.map(() => (
              <TableRow
                key={Math.random()}
                sx={{ "&:last-child td, &:last-child th": { border: 0 } }}
              >
                {columns?.map((item: IColumns, index: number) => {
                  if (item.render) {
                    return <>{item.render(item, index)}</>;
                  } else {
                    return (
                      <TableCell align="right" key={item.key}>
                        {item.title}
                      </TableCell>
                    );
                  }
                })}
              </TableRow>
            ))
          ) : (
            <Box p={2}>暂无数据</Box>
          )}
        </TableBody>
      </MuiTable>
    </TableContainer>
  );
}
