import axios from "axios";
// import Api from '../../../../commons/utils/api_manager'
// import CloudEStore from '../stores/CloudEStore'
// import { Actions, Constants } from '../../../../commons/utils/constants'
// import MessageUtil from '../../../../commons/utils/MessageUtil'
// import ApiUtils from '../../../../commons/utils/ApiUtils'
import { APIOPTION, urlToken, ZONEID } from "./raysyncApi";
// import UserStore from '../../../../console/common/stores/UserStore'
import { ApiUtils } from "./utils";
import Base64 from "crypto-js/enc-base64";
import Utf8 from "crypto-js/enc-utf8";
import { getLoaclStorageOfKey } from "./utils";

let headers: any = {
  "Content-Type": "application/json",
};

class CloudEController {
  // 新建文件夹
  static JobFileNewFolder(url: any, filetoken: string, projectId: string) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      url = url += urlToken(filetoken, projectId);
      headers["Content-Type"] = "multipart/form-data";
      return axios.post(
        APIOPTION() + "/createdir" + url,
        {},
        {
          headers: headers,
        }
      );
    }
  }
  //文件 删除
  static JobOutFileDel(urls: any, filetoken: string, projectId: string) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      headers["Cache-Control"] = "no-cache";
      headers["delfilepath"] = Base64.stringify(Utf8.parse(urls));
      let url = "";
      if (getLoaclStorageOfKey("userinfo")) {
        url += urlToken(filetoken, projectId);
      }
      return axios.get(APIOPTION() + "/delete/" + url, {
        headers: headers,
      });
      // .then(function (response) {
      //   console.log(response);
      // })
      // .catch(function (error) {
      //   console.log(error);
      // });
    }
  }
  // 文件树
  static JobOutFileDirtree(
    url: any,
    filetoken: string,
    projectId: string,
    showHide = false,
    items?: any
  ) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      headers["Cache-Control"] = "no-cache";
      if (getLoaclStorageOfKey("userinfo")) {
        url += urlToken(filetoken, projectId);
      }
      return axios.get(
        APIOPTION() + "/dirtree" + url + "&showhidden=" + showHide,
        {
          headers: headers,
        }
      );
    }
  }
  // 文件列表
  static JobOutFileList(
    url: any,
    filetoken: string,
    projectId: string,
    showHide = false,
    items?: any
  ) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      headers["Cache-Control"] = "no-cache";
      // headers['parentName'] = ''
      if (getLoaclStorageOfKey("userinfo")) {
        url += urlToken(filetoken, projectId);
      }
      return axios.get(
        APIOPTION() + "/list" + url + "&showhidden=" + showHide,
        {
          headers: headers,
        }
      );
    }
  }
  // 全局搜索 文件名
  static JobSearchFileList(
    url: any,
    base: any,
    filetoken: string,
    projectId: string,
    showHide = false
  ) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      headers["Cache-Control"] = "no-cache";
      if (getLoaclStorageOfKey("userinfo")) {
        url = urlToken(filetoken, projectId) + "&q=" + url;
      }
      return axios
      .get(APIOPTION() + "/search" + base + url + "&showhidden=" + showHide, {
        headers: headers,
      })
    }
  }

  // 文件移动
  // static JobOutFileListMove(url: any, filetoken: string, projectId: string) {
  //   if (ApiUtils.getAuthorizationHeaders(headers)) {
  //     headers["Cache-Control"] = "no-cache";
  //     if (getLoaclStorageOfKey("userinfo")) {
  //       url += urlToken(filetoken, projectId);
  //     }
  //     return axios.get(APIOPTION() + "/download" + url, {
  //       headers: headers,
  //     });
  //   }
  // }
  // 文件移动
  static JobFileMove(
    url: any,
    original_filepath: any,
    value: any,
    filetoken: string,
    projectId: string
  ) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      url = url += urlToken(filetoken, projectId);
      headers["Content-Type"] = "multipart/form-data";
      headers["originalfilepath"] = encodeURIComponent(original_filepath);
      let param = new FormData();
      param.append("", value);
      return axios.post(APIOPTION() + "/rename" + url, param, {
        headers: headers,
      });
    }
  }

  // 文件批量移动
  static JobFileBatchMove(
    url: any,
    original_filepath: Array<string>,
    value: any,
    filetoken: string,
    projectId: string
  ) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      url = url + urlToken(filetoken, projectId) + "&batch=true";
      headers["Content-Type"] = "multipart/form-data";
      // Base64.stringify(Utf8.parse(urls))
      // headers["originalfilepath"] = encodeURIComponent(
      //   original_filepath.join(" ")
      // );
      headers["originalfilepath"] = Base64.stringify(
        Utf8.parse(original_filepath.join(" "))
      );
      let param = new FormData();
      param.append("", value);
      return axios.post(APIOPTION() + "/rename" + url, param, {
        headers: headers,
      });
    }
  }
}
export default CloudEController;
