import React from 'react';
import ErrorOutlineIcon from '@material-ui/icons/ErrorOutline';
import makeStyles from "@material-ui/styles/makeStyles";
import { Grid } from '@material-ui/core';
import { Typography } from "@material-ui/core";
import { BACKEND_API_URI_PREFIX } from "@/commons/utils/api_prefix";

const useStyles = makeStyles({
    tipBody: { border: "1px solid rgba(19, 110, 250, 0.09)", borderRadius: "4px", display: "flex", alignItems: "center" },
    root: { marginRight: 0 },
    goText: {
        color: "rgb(19, 110, 250)",
        cursor: "pointer",
        '&:hover': {
            textDecoration: "underline"
        }
    }
})
export default props => {
    const { style, text, iconColor, backgroundColor, margin, manual } = props;
    const classes = useStyles()
    return (
        <Grid className={style ? style : classes.tipBody} style={{ backgroundColor: backgroundColor ? backgroundColor : "#FFEDED", margin: margin ? margin : "0" }} >
            <ErrorOutlineIcon style={{ color: iconColor ? iconColor : "#FF4E4E", margin: "0px 10px 0px 20px" }} fontSize="small" />
            <Typography style={{ fontSize: "12px", marginRight: "20px" ,padding:'12px 0'}}>
                {text || ''}
                {
                    manual ? (
                        <span className={classes.goText} onClick={()=>{
                            window.open(BACKEND_API_URI_PREFIX + '/helpce/docs/2027/about3', '_blank')
                        }}>
                            安装手册
                        </span>
                    ) : ""
                }
            </Typography>
        </Grid>
    )
}