/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-13 17:00:19
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-14 11:06:13
 * @FilePath: /bkunyun/src/store/modules/upload.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import { makeAutoObservable } from "mobx";

interface IUploadInfo {
  id: string,
  open: boolean,
  list: any,
  isPermanence: boolean,
}

/** 存储地图派单websocket推送数据状态的store  */
class FileList {
  constructor() {
    makeAutoObservable(this);
  }
  
  /** 文件上传列表 */
  fileList: IUploadInfo[] = [];

  setFileList (val: IUploadInfo[]) {
    this.fileList = val
  }

  /** 设置文件上传信息 */
  setUploadInfo(id: string, val: IUploadInfo) {
    const newFileList = this.fileList?.map((item)=>{
      if(item.id === id){
        return val
      } return item
    })
    this.fileList = newFileList
  }

  setUploadInfoOpen(id: string, val: boolean) {
    const newFileList = this.fileList?.map((item)=>{
        if(item.id === id){
          return {...item,open: val};
        } 
        return item;
      })
      this.fileList = newFileList
  }

  setUploadInfoList(id: string, val: any) {
    const newFileList = this.fileList?.map((item)=>{
        if(item.id === id){
          return {...item, list: val}
        } return item
      })
      this.fileList = newFileList
  }

  setUploadInfoIsPermanence(id: string, val: boolean) {
    const newFileList = this.fileList?.map((item)=>{
        if(item.id === id){
          return {...item, isPermanence: val}
        } return item
      })
      this.fileList = newFileList
    }
}


export default new FileList();
