import request from "@/utils/axios/service";
import Api from "./api_manager";

function current() {
  return request({
    url: Api.API_USER_FETCH,
    method: "get",
  });
}

function menu() {
  return request({
    url: "/accounts/menu-mock",
    method: "get",
  });
}

type projectListParams = {
  product: string;
  name?: string;
};

function product(params: projectListParams) {
  return request({
    url: Api.API_PROJECT_LIST,
    method: "get",
    params,
  });
}

export { current, menu, product };
