import style from "./NoProject.module.css";
import noData from "@/assets/project/noData.svg";
import { Button } from "@mui/material";
import AddIcon from "@mui/icons-material/Add";
import AddProject from "@/views/Project/components/AddProject";
import React from "react";

const NoProject = () => {
  let addProjectRef: any = React.createRef();

  const handleClickOpen = () => {
    addProjectRef.current.handleClickOpen();
  };

  return (
    <div className={style.noProject}>
      <img src={noData} alt="" className={style.noDataImg} />
      <div className={style.text1}>当前产品暂无项目</div>
      <div className={style.text2}>请先创建项目</div>
      <Button
        variant="contained"
        size="large"
        className={style.button}
        startIcon={<AddIcon />}
        onClick={handleClickOpen}
        style={{ backgroundColor: "#1370ff", color: "#fff" }}
      >
        创建项目
      </Button>
      <AddProject onRef={addProjectRef} />
    </div>
  );
};

export default NoProject;
