/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-01 09:15:10
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React, { memo, useEffect, useMemo, useState } from "react";

import style from "./index.module.css";
import useMyRequest from "@/hooks/useMyRequest";
import {
  getProject,
  hpczone,
  updateProject,
  deleteProject,
} from "@/api/project_api";
import { useStores } from "@/store";
import { toJS } from "mobx";
import { observer } from "mobx-react-lite";
import InformationDisplay from "@/components/InformationDisplay";
import classnames from "classnames";
import { Button } from "@mui/material";
import LoadingButton from "@mui/lab/LoadingButton";
import { useMessage } from "@/components/MySnackbar";
import Loading from "@/views/Loading";
import MyDialog from "@/components/mui/MyDialog";
import { getProjectList } from "../../project";

const reg = new RegExp("^[A-Za-z0-9\u4e00-\u9fa5]+$");

type zoneIdOption = {
  id: string;
  name: string;
};

const BaseInfo = observer(() => {
  const message = useMessage();
  const { currentProjectStore } = useStores();
  const [projectInfo, setProjectInfo] = useState<any>({});
  const [deleteProjectName, setDeleteProjectName] = useState("");
  const currentUserName = JSON.parse(
    localStorage.getItem("userInfo") || "{}"
  ).name;
  const { run, loading } = useMyRequest(getProject, {
    onSuccess: (result: any) => {
      setProjectInfo(result.data);
    },
  });
  useEffect(() => {
    run({
      id: currentProjectStore.currentProjectInfo.id as string,
    });
  }, [currentProjectStore.currentProjectInfo.id, run]);
  const [zoneIdMap, setZoneIdMap] = useState<Map<string, string>>(new Map());
  const [zoneIdOptions, setZoneIdOptions] = useState<Array<zoneIdOption>>([]);

  // 获取计算区信息
  const { run: getZone } = useMyRequest(hpczone, {
    onSuccess: (result: any) => {
      setZoneIdOptions(result);
      let zoneMap: Map<string, string> = new Map();
      result.forEach((item: zoneIdOption) => {
        zoneMap.set(item.id, item.name);
      });
      setZoneIdMap(zoneMap);
    },
  });

  useEffect(() => {
    getZone();
  }, [getZone]);

  // 项目信息展示数据转换
  const infoList = useMemo(() => {
    return [
      {
        label: "项目名称：",
        value: projectInfo.name,
      },
      {
        label: "项目描述：",
        value: projectInfo.desc,
      },
      {
        label: "计算区：",
        value: zoneIdMap.get(projectInfo.zoneId) || projectInfo.zoneId,
      },
      {
        label: "创建人：",
        value: projectInfo.owner,
      },
      {
        label: "扣费账号：",
        value: projectInfo.tenantUser,
      },
    ];
  }, [projectInfo, zoneIdMap]);

  const nameChange = (e: any) => {
    setProjectInfo({
      ...projectInfo,
      name: e.target.value,
    });
  };

  const descChange = (e: any) => {
    setProjectInfo({
      ...projectInfo,
      desc: e.target.value,
    });
  };

  const { run: updateProjectRun, loading: updateLoading } = useMyRequest(
    updateProject,
    {
      onSuccess: async (result: any) => {
        message.success("修改成功");
        const projectList = await getProjectList();
        currentProjectStore.setProjectList(projectList);
        currentProjectStore.changeProject(projectInfo);
      },
    }
  );

  // 修改项目
  const handleClickUpdate = () => {
    if (projectInfo.name) {
      if (reg.test(projectInfo.name)) {
        updateProjectRun({ ...projectInfo, product: "CADD" });
      } else {
        message.info(
          "格式不正确，必须在30字符以内，仅限大小写字母、数字、中文"
        );
      }
    } else {
      message.info("项目名称不能为空");
    }
  };

  const { run: deleteProjectRun, loading: deleteLoading } = useMyRequest(
    deleteProject,
    {
      onSuccess: async (result: any) => {
        message.success("删除成功");
        DialogRef.current.handleClose();
        const projectList = await getProjectList();
        currentProjectStore.setProjectList(projectList);
        currentProjectStore.changeProject(projectList[0]);
        setProjectInfo(projectList[0]);
      },
    }
  );

  let DialogRef: any = React.createRef();
  // 显示删除弹窗
  const handleClickDelete = () => {
    DialogRef.current.handleClickOpen();
  };

  const deleteProjectNameChange = (e: any) => {
    setDeleteProjectName(e.target.value);
  };

  // 删除项目
  const handleSubmitDelete = () => {
    if (
      deleteProjectName === toJS(currentProjectStore.currentProjectInfo.name)
    ) {
      deleteProjectRun({ id: projectInfo.id });
    } else {
      message.error("项目名称不匹配");
    }
  };

  if (loading) {
    return (
      <div className={style.loadingBox}>
        <Loading />
      </div>
    );
  } else if (currentUserName !== projectInfo.owner) {
    return <InformationDisplay infoList={infoList} />;
  } else {
    return (
      <div className={style.projectInfoList}>
        <div className={style.projectInfoListLi}>
          <div
            className={classnames({
              [style.projectInfoListLiLabel]: true,
              [style.projectInfoName]: true,
            })}
          >
            项目名称
          </div>
          <input
            value={projectInfo.name}
            className={style.projectInfoListLiValue}
            onChange={nameChange}
            maxLength={30}
            placeholder="请输入项目名称"
          ></input>
        </div>
        <div className={style.projectInfoListLi}>
          <div className={style.projectInfoListLiLabel}>项目描述</div>
          <textarea
            value={projectInfo.desc}
            className={classnames({
              [style.projectInfoListLiValue]: true,
              [style.projectInfoTextarea]: true,
            })}
            onChange={descChange}
            placeholder="项目描述限制100字以内"
            maxLength={100}
          ></textarea>
        </div>
        <div className={style.projectInfoListLi}>
          <div className={style.projectInfoListLiLabel}>计算区</div>
          <select
            value={projectInfo.zoneId}
            disabled
            className={classnames({
              [style.projectInfoListLiValue]: true,
              [style.projectInfoSelect]: true,
              [style.disable]: true,
            })}
          >
            {zoneIdOptions.map((option) => (
              <option key={option.id} value={option.id}>
                {option.name}
              </option>
            ))}
          </select>
        </div>
        <div className={style.projectInfoListLi}>
          <div className={style.projectInfoListLiLabel}>创建人</div>
          <input
            value={projectInfo.owner}
            disabled
            className={classnames({
              [style.projectInfoListLiValue]: true,
              [style.disable]: true,
            })}
          ></input>
        </div>
        <div className={style.projectInfoListLi}>
          <div className={style.projectInfoListLiLabel}>扣费账号</div>
          <input
            value={projectInfo.tenantUser}
            disabled
            className={classnames({
              [style.projectInfoListLiValue]: true,
              [style.disable]: true,
            })}
          ></input>
        </div>
        <div className={style.projectInfoListLi}>
          <LoadingButton
            variant="outlined"
            className={style.updateButton}
            onClick={handleClickUpdate}
            loading={updateLoading}
          >
            保存修改
          </LoadingButton>
        </div>
        <div className={style.projectInfoListLi}>
          <div className={style.projectInfoListLiLabel}>删除项目</div>
          <div className={style.projectInfoListLiText}>
            删除项目将删除其存储的数据和所有相关资源，并且已删除的项目无法恢复！请谨慎操作！
          </div>
          <Button
            variant="contained"
            className={style.updateButton}
            onClick={handleClickDelete}
            style={{
              backgroundColor: "#fff",
              color: "#FF4E4E",
              border: "1px solid #FF4E4E",
            }}
          >
            删除项目
          </Button>
        </div>
        <MyDialog
          handleSubmit={handleSubmitDelete}
          onRef={DialogRef}
          title="删除项目"
          submitloading={deleteLoading}
          submitStyle={{ background: "#FF4E4E", color: "#fff" }}
        >
          <div className={style.deleteBox}>
            <div className={style.deleteText1}>
              您要删除本项目。已删除的项目将无法恢复！您真的确定吗？
            </div>
            <div className={style.deleteText2}>
              此操作可能会导致数据丢失。为防止意外操作，我们要求您确认您的操作。
            </div>
            <div className={style.deleteText3}>
              请输入“
              <span className={style.deleteProjectName}>
                {currentProjectStore.currentProjectInfo.name}
              </span>
              ”以确认此操作。
            </div>
            <input
              value={deleteProjectName}
              className={style.deleteProjectInput}
              onChange={deleteProjectNameChange}
              maxLength={30}
              placeholder="请输入项目名称"
            ></input>
          </div>
        </MyDialog>
      </div>
    );
  }
});

export default memo(BaseInfo);
