import style from "./InformationDisplay.module.css";

type InfoLi = {
  label: string | number;
  value: string | number;
};

type InfoList = Array<InfoLi>;

type InformationDisplayProps = {
  infoList: InfoList;
};

const InformationDisplay = (props: InformationDisplayProps) => {
  const { infoList } = props;
  return (
    <div className={style.infoList}>
      {infoList.map((item) => {
        return (
          <div className={style.infoListLi} key={item.label}>
            <div className={style.infoListLiLabel}>{item.label}</div>
            <div className={style.infoListLiValue}>{item.value}</div>
          </div>
        );
      })}
    </div>
  );
};

export default InformationDisplay;
