import React, { useMemo } from 'react';
import { withStyles } from '@material-ui/core/styles';
import Dialog from '@material-ui/core/Dialog';
import MuiDialogTitle from '@material-ui/core/DialogTitle';
import MuiDialogContent from '@material-ui/core/DialogContent';
import MuiDialogActions from '@material-ui/core/DialogActions';
import IconButton from '@material-ui/core/IconButton';
import CloseIcon from '@material-ui/icons/Close';
import Typography from '@material-ui/core/Typography';
import Slide from '@material-ui/core/Slide';
import ButtonComponent from "@/commons/components/Material.Ui/Button";
import useMediaQuery from '@material-ui/core/useMediaQuery';
import { useTheme } from '@material-ui/core/styles';
import PropTypes from "prop-types";
import { CLOUDE } from "@/commons/utils/constants"
import { useEffect } from 'react';

const styles = (theme) => ({
    root: {
        margin: 0,
        padding: "16px 24px",
    },
    closeButton: {
        position: 'absolute',
        right: theme.spacing(1),
        top: theme.spacing(1) - 4,
        color: theme.palette.grey[500],
    },
});

const DialogTitle = withStyles(styles)((props) => {
    const { children, classes, onClose, ...other } = props;
    return (
        <MuiDialogTitle disableTypography className={classes.root} {...other}>
            <Typography variant="body1">{children}</Typography>
            {onClose ? (
                <IconButton aria-label="close" className={classes.closeButton} onClick={() => onClose(false)}>
                    <CloseIcon />
                </IconButton>
            ) : null}
        </MuiDialogTitle>
    );
});


const DialogActions = withStyles(() => ({
    root: {
        margin: 0,
        padding: "16px 24px",
        "& > :not(:first-child)": {
            marginLeft: "15px"
        }
    },

}))(MuiDialogActions);


const Transition = React.forwardRef(function Transition(props, ref) {
    return <Slide direction={props.direction || "up"} ref={ref} {...props} />;
});
const AlertDialogSlide = props => {
    const { open, handleClose, dividers, content, padding = true,confirmDisabled=false, header, canncel = CLOUDE.canncel, confirm = CLOUDE.confirm, fullScreen, scroll, maxWidth, bottom, backAndKey, direction, classes, contentStyle } = props;
    const theme = useTheme();
    const mediaFull = useMediaQuery(theme.breakpoints.down('sm'));
    const [fullWidth, setFullWidth] = React.useState(true);
    const DialogContent = withStyles(() => ({
        root: {
            padding: padding ? "20px 24px 40px" : "0", fontWeight: "400", ...contentStyle
        },
        dividers: { borderColor: "rgba(34, 34, 34, 0.08)" },

    }))(MuiDialogContent);
    const otherName = useMemo(() => { return (content) }, [content])


    return (
        <Dialog
            open={open}
            classes={classes}
            TransitionComponent={Transition}
            keepMounted
            onClose={() => handleClose(false)}
            fullScreen={fullScreen || mediaFull}
            scroll={scroll || "paper"}
            aria-describedby="dialog"
            aria-labelledby="confirmation-dialog-title"
            fullWidth={fullWidth}
            // disableBackdropClick={backAndKey || true}//点击屏幕外关闭
            // disableEscapeKeyDown={backAndKey || true}//按下键盘ESC关闭
            maxWidth={maxWidth || "sm"}
        >
            <DialogTitle id="customized-dialog-title" onClose={handleClose}>
                {header || ""}
            </DialogTitle>
            <DialogContent dividers={dividers || true}>
                {/* {content || ""} */}

                {otherName}
            </DialogContent>
            {
                !bottom && (canncel || confirm) && <DialogActions>
                    {canncel && <ButtonComponent click={() => handleClose(false)} variant={"outlined"} text={canncel} />}
                    {confirm && <ButtonComponent click={() => handleClose(1)} text={confirm} disabled={ confirmDisabled || false} />}
                </DialogActions>
            }
            {
                bottom && bottom
            }
        </Dialog>
    )
}
AlertDialogSlide.propTypes = {
    maxWidth: PropTypes.oneOf([false, "xs", "sm", "md", "lg", "xl"]),
    scroll: PropTypes.oneOf(['paper', 'body'])
};
export default AlertDialogSlide