/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-01 16:53:15
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-02 10:16:28
 * @FilePath: /bkunyun/src/components/Material.Ui/Table/ActionsComponent.jsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React from 'react';
import PropTypes from 'prop-types';

import Button from "@mui/material/Button";
import IconButton from '@mui/material/IconButton';
import FirstPageIcon from '@mui/icons-material/FirstPage';
import KeyboardArrowLeft from '@mui/icons-material/KeyboardArrowLeft';
import KeyboardArrowRight from '@mui/icons-material/KeyboardArrowRight';
import LastPageIcon from '@mui/icons-material/LastPage';
import { makeStyles } from "@mui/styles";
const useStyles = makeStyles({
    firstPageIconStyle: { width: '28px', height: '28px', padding: 0, backgroundColor: '#FFFFFF', borderRadius: '2px', border: '1px solid #D8D8D8', margin: "0 6px" },
    KeyboardArrowLeftStyle:{ width: '28px', height: '28px', padding: 0, backgroundColor: '#FFFFFF', borderRadius: '2px', border: '1px solid #D8D8D8', marginRight: "3px" },
    keyboardArrowRightStyle:{ width: '28px', height: '28px', padding: 0, backgroundColor: '#FFFFFF', borderRadius: '2px', border: '1px solid #D8D8D8', marginLeft: "3px" },
    lastPageIconStyle:{ width: '28px', height: '28px', padding: 0, backgroundColor: '#FFFFFF', borderRadius: '2px', border: '1px solid #D8D8D8', margin: "0 6px" }
})

const TablePaginationActionsConsole = props => {
    const classes = useStyles();
    const { count, page, rowsPerPage, onChangePage } = props;
    const handleFirstPageButtonClick = (event) => {
        onChangePage(event, 0);
    }
    const handleBackButtonClick = (event) => {
        onChangePage(event, page - 1);
    }
    const handleNextButtonClick = (event) => {
        onChangePage(event, page + 1);
    }
    const btnClick = (event, item) => {
        onChangePage(event, item);
    }
    const handleLastPageButtonClick = (event) => {
        onChangePage(event, Math.max(0, Math.ceil(count / rowsPerPage) - 1));
    }
    const buttons = (count, page, rowsPerPage) => {
        let max = 1;
        if( rowsPerPage !== -1 ){
            max = count % rowsPerPage === 0 ? count / rowsPerPage : parseInt(count / rowsPerPage) + 1;
        }
        let arr = [...Array(max).keys()];
        return arr.map((item) => {
            if (item - 4 <= page && item + 4 >= page && count > 4)
                return <Button
                    key={item}
                    onClick={() => btnClick('', item)}
                    style={{ minWidth: '28px', marginRight: "3px", marginLeft: "3px", minHeight: '28px', lineHeight: '28px', fontSize: "12px", border: page === item ? "1px solid #136EFA" : "1px solid #D8D8D8", color: page === item ? "#fff" : "#111111", background: page === item ? '#136EFA' : "#fff", borderRadius: "2px", padding: '0' }}>
                    {item + 1}
                </Button>
            return ""
        })
    }
    return (
        <div style={{ flexShrink: 0, }}>
            <IconButton
                onClick={handleFirstPageButtonClick}
                disabled={page === 0}
                className={classes.firstPageIconStyle}
                aria-label="first page"
            >
                <FirstPageIcon />
            </IconButton>
            <IconButton
                className = { classes.KeyboardArrowLeftStyle }
                onClick={handleBackButtonClick} disabled={page === 0} aria-label="previous page">
                <KeyboardArrowLeft />
            </IconButton>
            {
                buttons(count, page, rowsPerPage)
            }
            <IconButton
                onClick={handleNextButtonClick}
                className={classes.keyboardArrowRightStyle}
                disabled={page >= Math.ceil(count / rowsPerPage) - 1}
                aria-label="next page"
            >
                <KeyboardArrowRight />
            </IconButton>
            <IconButton
                className={classes.lastPageIconStyle}
                onClick={handleLastPageButtonClick}
                disabled={page >= Math.ceil(count / rowsPerPage) - 1}
                aria-label="last page"
            >
                <LastPageIcon />
            </IconButton>
        </div>
    );
}

TablePaginationActionsConsole.propTypes = {
    count: PropTypes.number.isRequired,
    onChangePage: PropTypes.func.isRequired,
    page: PropTypes.number.isRequired,
    rowsPerPage: PropTypes.number.isRequired,
};

export default TablePaginationActionsConsole