/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-07 15:55:26
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// import Dialog from "@/components/Material.Ui/Dialog";
import { IResponse, useHttp } from "@/api/http";
import Dialog from "@/components/mui/Dialog";
import { useMessage } from "@/components/MySnackbar";
import { useStores } from "@/store";
import { toJS } from "mobx";
import { observer } from "mobx-react-lite";
import { memo } from "react";
import { IDialogInfo } from "../interface";

interface IProps {
  setRemoveDialog: (val: IDialogInfo) => void;
  removeDialog: IDialogInfo;
  getTableList: () => void;
}

const RemoveItem = observer((props: IProps) => {
  const { removeDialog, setRemoveDialog, getTableList } = props;

  const http = useHttp();
  const Message = useMessage();
  const { currentProjectStore } = useStores();

  const onClose = () => {
    setRemoveDialog({ isShow: false, username: "" });
  };
  const onConfirm = () => {
    const projectInfo = toJS(currentProjectStore?.currentProjectInfo);
    console.log(111111, {
      id: projectInfo?.id || "",
      username: removeDialog.username,
    });
    http
      .del<IResponse<any>>(
        `/cpp/project/removemember?id=${projectInfo?.id || ""}&username=${
          removeDialog.username || ""
        }`
      )
      .then((res) => {
        const { errorCode } = res;
        if (errorCode === 0) {
          Message.success("移出成功！");
          getTableList();
          setRemoveDialog({ isShow: false, username: "" });
        }
      });
  };
  return (
    <>
      <Dialog
        open={removeDialog?.isShow}
        onClose={onClose}
        onConfirm={onConfirm}
        title="移出项目"
      >
        <div>确认移出该成员吗？</div>
      </Dialog>
    </>
  );
});

export default memo(RemoveItem);
