/*
 * @Author: rocosen
 * @Date: 2022-06-12 10:05:13
 * @LastEditors: rocosen
 * @LastEditTime: 2022-06-07 20:23:02
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useState, useMemo, useEffect } from "react";

import { Box } from "@mui/system";
import { useStores } from "@/store/index";
import NoProject from "@/components/NoProject";
import { observer } from "mobx-react-lite";
import projectImg from "@/assets/project/projectIconSmall.svg";
import WorkbenchTemplate from "./workbenchTemplate";
import WorkbenchList from "./workbenchList";
import Tabs from "@/components/mui/Tabs";
import usePass from "@/hooks/usePass";

const ProjectWorkbench = observer(() => {
    const { currentProjectStore } = useStores();
    const isPass = usePass();
    const [value, setValue] = useState("workbenchTemplate");

    
    useEffect(() => {
        console.log(isPass("PROJECT_WORKBENCH_FLOES_USE",'USER'), "11111111111");
    }, [])

    const tabList = useMemo(() => {
        return [
            {
                label: "工作流模版",
                value: "workbenchTemplate",
                component: <WorkbenchTemplate />,
            },
            {
                label: "任务列表",
                value: "workbenchList",
                component: <WorkbenchList />,
            },
        ];
    }, []);

    const changeTabs = (val: string) => {
        setValue(val);
    };

    return (
        <div style={{ padding: 24 }}>
            <div style={{ display: "flex", alignItems: "center" }}>
                <img src={projectImg} alt="项目logo" />
                <span style={{ marginLeft: 12 }}>
                    工作台
                </span>
            </div>
            <Box sx={{ width: "100%", typography: "body1" }}>
                <Tabs value={value} onChange={changeTabs} tabList={tabList} />
            </Box>
        </div>
    );
});

export default memo(ProjectWorkbench);
