import logo from "@/assets/project/projectIcon.svg";
import style from "./index.module.css";
import ArrowForwardIosIcon from "@mui/icons-material/ArrowForwardIos";
import { Popper, Fade } from "@mui/material";
import { useStores } from "@/store/index";
import ProjectListPopper from "../ProjectListPopper";
import React, { useEffect, useState } from "react";
import { observer } from "mobx-react-lite";
import AddProject from "../AddProject";
import { setFileServerEndPointLocalStorage } from "@/views/Project/project";

const CurrentProject = observer(() => {
  const { currentProjectStore } = useStores();
  // let addProjectRef: any = React.createRef();
  const [projectListOpen, setProjectListOpen] = useState(false);
  const [addProjectOpen, setAddProjectOpen] = useState(false);
  const [anchorEl, setAnchorEl] = useState<null | HTMLElement>(null);

  // 结合handleShowProjectList中的event.nativeEvent.stopImmediatePropagation();实现点击空白区域隐藏项目列表
  useEffect(() => {
    document.addEventListener("click", (e) => {
      setProjectListOpen(false);
    });
  }, []);

  const handleShowProjectList = (event: React.MouseEvent<HTMLElement>) => {
    event.nativeEvent.stopImmediatePropagation();
    setAnchorEl(event.currentTarget);
    setProjectListOpen((previousOpen) => !previousOpen);
  };
  const canBeOpen = projectListOpen && Boolean(anchorEl);
  const id = canBeOpen ? "spring-popper" : undefined;
  const handleChangeCurrentProject = (project: any) => {
    currentProjectStore.changeProject(project);
    setFileServerEndPointLocalStorage(project.zoneId);
    setProjectListOpen(!projectListOpen);
  };

  const openAddProject = () => {
    // addProjectRef.current.handleClickOpen();
    setAddProjectOpen(true);
    setProjectListOpen(false);
  };

  return (
    <div>
      <div
        className={style.currentProject}
        aria-describedby={id}
        onClick={handleShowProjectList}
      >
        <img src={logo} alt="" className={style.logo} />
        <div className={style.info}>
          <div className={style.name}>
            {currentProjectStore.currentProductInfo.name || "CADD"}
          </div>
          <div className={style.desc}>
            {currentProjectStore.currentProjectInfo.name || "暂无项目"}
          </div>
        </div>
        <ArrowForwardIosIcon
          className={style.showProjectList}
          style={{ fontSize: 12 }}
        />
      </div>
      <AddProject open={addProjectOpen} />
      <Popper
        id={id}
        open={projectListOpen}
        anchorEl={anchorEl}
        placement="right-start"
        transition
        style={{ zIndex: 100 }}
      >
        {({ TransitionProps }) => (
          <Fade {...TransitionProps} timeout={350}>
            <div>
              <ProjectListPopper
                handleClickOpen={openAddProject}
                handleChangeCurrentProject={handleChangeCurrentProject}
              />
            </div>
          </Fade>
        )}
      </Popper>
    </div>
  );
});

export default CurrentProject;
