import { Box, List } from "@mui/material";
// import CurrentProject from "./CurrentProject";
import CurrentProject from "../Project/components/CurrentProject";
import React from "react";
import { Outlet, useNavigate } from "react-router-dom";
import style from "./index.module.css";
import { observer } from "mobx-react-lite";
import { useStores } from "@/store/index";
import classnames from "classnames";

const MenuLayout = observer(() => {
  const { permissionStore } = useStores();
  let pathname = new URL(window.location.href).pathname;

  const navigate = useNavigate();

  return (
    <Box className={style.container}>
      <Box className={style.aside}>
        <CurrentProject />
        <List className={style.list}>
          {permissionStore.sidebarRouters.map((item, index) => {
            return (
              <li
                key={"sidebar" + index}
                className={classnames({
                  [style.listItem]: true,
                  [style.active]: item.path === pathname,
                })}
                onClick={() => item.type === "page" && navigate(item.path)}
              >
                {item.name}
              </li>
            );
          })}
        </List>
      </Box>
      <Box className={style.content}>
        <Outlet></Outlet>
      </Box>
    </Box>
  );
});

export default MenuLayout;
