import axios from "axios";
// import Api from '../../../../commons/utils/api_manager'
// import CloudEStore from '../stores/CloudEStore'
// import { Actions, Constants } from '../../../../commons/utils/constants'
// import MessageUtil from '../../../../commons/utils/MessageUtil'
// import ApiUtils from '../../../../commons/utils/ApiUtils'
import { APIOPTION, urlToken, ZONEID } from "./raysyncApi";
// import UserStore from '../../../../console/common/stores/UserStore'
import { ApiUtils } from "./utils";
import Base64 from "crypto-js/enc-base64";
import Utf8 from "crypto-js/enc-utf8";
import { getLoaclStorageOfKey } from "./utils";

let headers: any = {
  "Content-Type": "application/json",
};

class CloudEController {
  //文件 删除
  static JobOutFileDel(urls: any,filetoken: string) {
    if (
      ApiUtils.getAuthorizationHeaders(headers)
    ) {
      headers["Cache-Control"] = "no-cache";
      headers["delfilepath"] = Base64.stringify(Utf8.parse(urls));
      let url = "";
      if (getLoaclStorageOfKey("userinfo")) {
        url += urlToken(filetoken);
      }
      axios
        .get(APIOPTION() + "/delete/" + url, {
          headers: headers,
        })
        .then(function (response) {
          console.log(response)
        })
        .catch(function (error) {
          console.log(error)
        });
    }
  }
  // 文件列表
  static JobOutFileList(
    url: any,
    showHide = false,
    filetoken: string,
    items?: any
  ) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      headers["Cache-Control"] = "no-cache";
      // headers['parentName'] = ''
      if (getLoaclStorageOfKey("userinfo")) {
        url += urlToken(filetoken);
      }
      axios
        // 查看文件的接口为list(可查看隐藏文件)
        .get(APIOPTION() + "/list" + url + "&showhidden=" + showHide, {
          headers: headers,
        })
        .then(function (response) {
          console.log(response);
          // Array.isArray(response.data)
          //   ? CloudEStore.setjobOutFileList(response.data)
          //   : CloudEStore.setjobOutFileList([]);
          // CloudEStore.emitChange(
          //   Actions.JobOutFileList,
          //   true,
          //   Actions.JobOutFileList,
          //   items
          // );
        })
        .catch(function (error) {
          console.log(error);
          // MessageUtil.handleError(CloudEStore, error);
          // CloudEStore.emitChange(Actions.JobOutFileList, false);
        });
    }
  }
  // 文件移动
  static JobOutFileListMove(url: any, filetoken: string) {
    if (
      ApiUtils.getAuthorizationHeaders(headers)
    ) {
      headers["Cache-Control"] = "no-cache";
      if (getLoaclStorageOfKey("userinfo")) {
        url += urlToken(filetoken);
      }
      axios
        .get(APIOPTION() + "/download" + url, {
          headers: headers,
        })
        .then(function (response) {
          console.log(response)
        })
        .catch(function (error) {
          console.log(error);
        });
    }
  }
  // // 全局搜索 文件名
  static JobSearchFileList(url: any, base: any, showHide = false, filetoken: string) {
    if (
      ApiUtils.getAuthorizationHeaders(headers)
    ) {
      headers["Cache-Control"] = "no-cache";
      if (getLoaclStorageOfKey("userinfo")) {
        url = urlToken(filetoken) + "&q=" + url;
      }
      axios
        .get(APIOPTION() + "/search" + base + url + "&showhidden=" + showHide, {
          headers: headers,
        })
        .then(function (response) {
          console.log(response)
        })
        .catch(function (error) {
          console.log(error);
        });
    }
  }

  // 文件移动
  static JobFileMove(url: any, original_filepath: any, value: any, filetoken: string) {
    if (ApiUtils.getAuthorizationHeaders(headers)) {
      url = url += urlToken(filetoken)
      headers['Content-Type'] = 'multipart/form-data';
      headers['originalfilepath'] = encodeURIComponent(original_filepath)
      let param = new FormData()
      param.append('', value)
      axios
        .post(APIOPTION() + '/rename' + url, param, {
          headers: headers
        })
        .then(response => {
          console.log(response)
        })
        .catch(error => {
          console.log(error)
        })
    }
  }
}
export default CloudEController;
