import React, { Fragment, ReactNode } from "react";
import { Snackbar, Alert, Fade, Grow } from "@mui/material";
import useMySnackbar from "./useMySnackbar";
import snackbarContext from "./snackbarContext";

type MySnackbarProviderProp = {
  vertical?: "bottom" | "top";
  horizontal?: "center" | "left" | "right";
  autoHideDuration?: number;
  snackerClasses?: object;
  ClickAwayListenerProps?: object;
  ContentProps?: object;
  disableWindowBlurListener?: boolean;
  resumeHideDuration?: number;
  snackbarSx?: object;
  transition?: "grow" | "fade";
  transitionDuration?: number;
  TransitionProps?: object;
  alertClasses?: object;
  closeText?: string;
  variant?: "filled" | "outlined" | "standard";
  errorIcon?: ReactNode;
  infoIcon?: ReactNode;
  successIcon?: ReactNode;
  warningIcon?: ReactNode;
  elevation?: number;
  alertSx?: object;
  children?: ReactNode;
};

const getTransitionComponent = (transition: "grow" | "fade") => {
  switch (transition) {
    case "grow":
      return Grow;
    case "fade":
      return Fade;
    default:
      return Grow;
  }
};

const MySnackbarProvider = ({
  vertical = "top",
  horizontal = "center",
  autoHideDuration = 2000,
  snackerClasses,
  ClickAwayListenerProps,
  ContentProps,
  disableWindowBlurListener = true,
  resumeHideDuration,
  snackbarSx,
  transition = "grow",
  transitionDuration,
  TransitionProps = {},
  alertClasses,
  closeText = "Close",
  variant = "standard",
  errorIcon,
  infoIcon,
  successIcon,
  warningIcon,
  elevation = 3,
  alertSx,
  children,
}: MySnackbarProviderProp) => {
  const {
    open,
    messageInfo,
    handleExited,
    success,
    error,
    warning,
    info,
    close,
  } = useMySnackbar();
  return (
    <Fragment>
      <Snackbar
        open={open}
        autoHideDuration={autoHideDuration}
        onClose={close}
        anchorOrigin={{ vertical: vertical, horizontal: horizontal }}
        classes={snackerClasses}
        ClickAwayListenerProps={ClickAwayListenerProps}
        ContentProps={ContentProps}
        disableWindowBlurListener={disableWindowBlurListener}
        resumeHideDuration={resumeHideDuration}
        sx={snackbarSx}
        TransitionComponent={getTransitionComponent(transition)}
        transitionDuration={transitionDuration}
        TransitionProps={{ onExited: handleExited, ...TransitionProps }}
      >
        <Alert
          id="Alert"
          classes={alertClasses}
          closeText={closeText}
          iconMapping={{
            error: errorIcon,
            info: infoIcon,
            success: successIcon,
            warning: warningIcon,
          }}
          severity={messageInfo?.severity}
          variant={variant}
          elevation={elevation}
          sx={{ boxShadow: "unset", ...alertSx }}
        >
          {messageInfo?.content}
        </Alert>
      </Snackbar>
      <snackbarContext.Provider value={{ success, error, warning, info }}>
        {children}
      </snackbarContext.Provider>
    </Fragment>
  );
};

export default MySnackbarProvider;
