/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-07 20:31:40
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo } from "react";
import { isEqual } from "lodash";

import { Box } from "@mui/system";
import Tab from "@mui/material/Tab";
import { TabContext, TabList, TabPanel } from "@mui/lab";

interface ITabList {
  label: string;
  value: string;
  component: JSX.Element;
}

interface IProps {
  value: string;
  onChange: (val: string) => void;
  tabList: ITabList[];
}

const Tabs = (props: IProps) => {
  const { value, onChange, tabList } = props;
  return (
    <TabContext value={value}>
      <Box sx={{ borderBottom: 1, borderColor: "#F0F2F5" }}>
        <TabList
          onChange={(e: any, val: string) => {
            onChange(val);
          }}
          aria-label="lab API tabs example"
        >
          {tabList?.map((item) => {
            return (
              <Tab label={item.label} value={item.value} key={item.value} />
            );
          })}
        </TabList>
      </Box>
      {tabList?.map((item) => {
        return (
          <TabPanel
            sx={{ padding: "20px 0 0 0" }}
            value={item.value}
            key={item.value}
          >
            {item.component}
          </TabPanel>
        );
      })}
    </TabContext>
  );
};
const handleEqual = (prvProps: IProps, nextProps: IProps) => {
  if (isEqual(prvProps, nextProps)) {
    return true;
  }
  return false;
};

export default memo(Tabs, handleEqual);
