/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-05-31 15:15:59
 * @FilePath: /bkunyun/src/router/index.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
import { AnyMap } from "immer/dist/internal";
 */
import ConsoleLayout from "@/views/ConsoleLayout";
import Home from "@/views/Home";
import MenuLayout from "@/views/MenuLayout";
import * as React from "react";
import NotFound from "@/views/404";
import Demo from "@/views/demo";
import ProjectSetting from "@/views/Project/ProjectSetting";
import ProjectData from "@/views/Project/ProjectData";
export type route = {
  id?: string;
  type: "page";
  name: string;
  path: string;
  element: React.FC<{ childrenRoutes?: Array<route | operation> }>;
  icon?: string;
  show?: boolean;
  children?: Array<route | operation>;
};

export type navigate = {
  type: "navigate";
  from: string;
  to: string;
};

export type operation = {
  id: string;
  type: "operation";
  name: string;
};

export const elements: {
  [x: string]: ({
    childrenRoutes,
  }: {
    childrenRoutes?: Array<route | operation>;
  }) => JSX.Element | any;
} = {
  Demo: Demo,
  ProjectSetting: ProjectSetting,
  ProjectData: ProjectData,
};

export const routes: Array<route | navigate> = [
  {
    type: "navigate",
    from: "/",
    to: "/home",
  },
  {
    type: "navigate",
    from: "/product",
    to: "/home",
  },
  {
    type: "page",
    name: "Console",
    path: "/",
    element: ConsoleLayout,
    children: [
      {
        type: "page",
        name: "Home",
        path: "/home",
        element: Home,
      },
      {
        type: "page",
        name: "Product",
        path: "/product",
        element: MenuLayout,
        children: [],
      },
    ],
  },
  {
    type: "page",
    name: "404",
    path: "*",
    element: NotFound,
  },
];
