import React, { useState, useImperativeHandle } from "react";

import { TextField } from "@mui/material";
import MyDialog from "@/components/mui/MyDialog";
import { checkIsNumberLetterChinese } from "@/utils/util";
import { useMessage } from "@/components/MySnackbar";
const AddFolder = (props: any) => {
  const { list } = props;
  const Message = useMessage();
  let addFolderDialogRef: any = React.createRef();

  const showDialog = () => {
    addFolderDialogRef.current.handleClickOpen();
  };

  useImperativeHandle(props.onRef, () => {
    return {
      showDialog: showDialog,
    };
  });

  const handleAddSubmit = () => {
    if (fileName && !fileNameCheck.error) {
      // 请求接口
    } else {
      Message.info(fileNameCheck.help || "请输入文件夹名称");
    }
  };

  const addFolderSubmitloading = false;
  const [fileName, setFileName] = useState("");
  const [fileNameCheck, setFileNameCheck] = useState({
    error: false,
    help: "",
  });
  const handleFileNameChange = (e: any) => {
    const fileName = e.target.value;
    setFileName(fileName);
    //     1.“格式不正确，必须在30字符以内，仅限大小写字母、数字、中文”

    // 2. “文件夹名称不能为空”

    // 3. “已存在同名文件夹”
    if (!fileName) {
      setFileNameCheck({
        error: true,
        help: "文件夹名称不能为空",
      });
    } else if (!checkIsNumberLetterChinese(fileName) || fileName.length > 30) {
      setFileNameCheck({
        error: true,
        help: "格式不正确，必须在30字符以内，仅限大小写字母、数字、中文",
      });
    } else if (isRepeat(fileName)) {
      setFileNameCheck({
        error: true,
        help: "已存在同名文件夹",
      });
    } else {
      setFileNameCheck({
        error: false,
        help: "",
      });
    }
  };

  const isRepeat = (fileName: string) => {
    return list.some((item: any) => {
      return item.name === fileName;
    });
  };

  return (
    <MyDialog
      handleSubmit={handleAddSubmit}
      onRef={addFolderDialogRef}
      title="新建文件夹"
      submitloading={addFolderSubmitloading}
    >
      <TextField
        sx={{
          width: "388px",
          border: "1px solide #E6E8EB",
          marginTop: "12px",
        }}
        required
        error={fileNameCheck.error}
        id="fileName"
        label="名称"
        variant="outlined"
        value={fileName}
        onChange={handleFileNameChange}
        helperText={fileNameCheck.help}
        size="small"
      />
    </MyDialog>
  );
};

export default AddFolder;
