import React, { useState, useImperativeHandle, useCallback } from "react";

import style from "./index.module.css";
import { TextField } from "@mui/material";
import MyDialog from "@/components/mui/MyDialog";
import { Button } from "@mui/material";
import { checkIsNumberLetterChinese } from "@/utils/util";
import { useMessage } from "@/components/MySnackbar";
import { useDropzone } from "react-dropzone";
import Table from "@/components/Material.Ui/Table";
import fileIcon from "@/assets/project/fileIcon.svg";
import noFile from "@/assets/project/noFile.svg";
import uploaderIcon from "@/assets/project/uploaderIcon.svg";
import classnames from "classnames";
import { getMbfromB } from "@/utils/util";

const UpLoaderFile = (props: any) => {
  const message = useMessage();
  const [fileList, setFileList] = useState<any>([]);
  // list 是项目数据table的数据
  const { path, list } = props;

  const onDrop = useCallback(
    (acceptedFiles: any) => {
      // 判断是否有文件名重复
      const fileListRepeatName = getRepeatName(fileList, acceptedFiles);
      const listRepeatName = getRepeatName(list, acceptedFiles);
      if (fileListRepeatName || listRepeatName) {
        message.error(`${fileListRepeatName || listRepeatName}文件已存在`);
        return;
      }
      // 插入新的文件列表
      const popLength = 10 - fileList.length;
      let newFileList = [...acceptedFiles.slice(0, popLength), ...fileList];
      setFileList(newFileList);
    },
    [fileList, list, message]
  );

  const getRepeatName = (fList: Array<any>, Alist: Array<any>) => {
    let repeatName = "";
    Alist.forEach((aItem) => {
      fList.forEach((fItem: any) => {
        if (fItem.name === aItem.name) {
          repeatName = fItem.name;
        }
      });
    });
    return repeatName;
  };

  const { getRootProps, getInputProps, isDragActive } = useDropzone({ onDrop });

  const submitloading = false;

  let dialogRef: any = React.createRef();

  const handleSubmit = () => {
    console.log("handleSubmit");
  };

  const showDialog = () => {
    dialogRef.current.handleClickOpen();
  };

  useImperativeHandle(props.onRef, () => {
    return {
      showDialog: showDialog,
    };
  });

  const fileListHeadCells = [
    { id: "name", numeric: false, label: "名称", width: "60%" },
    { id: "size", numeric: false, label: "大小", width: "25%" },
    { id: "caozuo", numeric: false, label: "操作", width: "15%" },
  ];

  const renderName = (item: any) => {
    return (
      <span className={style.fileIconBox}>
        <img className={style.fileIcon} src={fileIcon} alt="" />
        {item.name}
      </span>
    );
  };
  // 1,048,576
  const renderSize = (item: any) => {
    return (
      <span>{item.size ? `${getMbfromB(Number(item.size))}MB` : "-"}</span>
    );
  };

  const handleRowDelete = (index: number) => {
    fileList.splice(index, 1);
    setFileList([...fileList]);
  };

  const renderButtons = (item: any, index: number) => {
    return (
      <span>
        <Button
          sx={{ position: "relative", left: "-18px" }}
          variant="text"
          size="small"
          color="error"
          onClick={() => handleRowDelete(index)}
        >
          删除
        </Button>
      </span>
    );
  };

  return (
    <MyDialog
      handleSubmit={handleSubmit}
      onRef={dialogRef}
      title="上传文件"
      submitloading={submitloading}
      submitText="开始上传"
      showCloseButton={false}
    >
      <div className={style.uploderBox}>
        <div className={style.uploderBoxLeft}>
          <div className={style.dropTitle}>添加文件</div>

          {/* <div {...getRootProps()} className={style.dropBox}> */}
          <div
            {...getRootProps()}
            className={classnames({
              [style.dropBox]: true,
              [style.dropBoxDragActive]: isDragActive,
            })}
          >
            {/* isDragActive */}
            <input {...getInputProps()} multiple />
            <img className={style.uploaderIcon} src={uploaderIcon} alt="" />
            <div className={style.uploderText1}>
              点击添加文件或将文件拖到此处添加
            </div>
            <div className={style.uploderText2}>一次最多添加10个文件</div>
          </div>
        </div>
        <div className={style.fileListBox}>
          <div className={style.dropTitle}>
            已添加文件
            <span
              className={classnames({
                [style.red]: fileList.length >= 10,
              })}
            >
              （{fileList.length}/10）
            </span>
          </div>
          <div className={style.tableBox}>
            <Table
              rowHover={true}
              stickyheader={true}
              rows={fileList.map((item: any, index: number) => ({
                ...item,
                name: renderName(item),
                size: renderSize(item),
                caozuo: renderButtons(item, index),
              }))}
              rowsPerPage={"99"}
              headCells={fileListHeadCells}
              nopadding={true}
              footer={false}
              headTableCellStyle={{
                fontSize: "12px",
                lineHeight: "20px",
                color: "#8A9099",
                // padding: "12px 24px",
              }}
              tableBoySx={{
                backgroundColor:
                  fileList.length >= 10 ? "rgba(255, 0, 0, 0.6)" : "",
              }}
            ></Table>
          </div>
          {fileList.length === 0 && (
            <div className={style.noFile}>
              <img className={style.noFileIcon} src={noFile} alt="" />
              <span className={style.noFileText}>暂无添加文件</span>
            </div>
          )}
        </div>
      </div>
    </MyDialog>
  );
};

export default UpLoaderFile;
