import * as React from "react";
import FormGroup from "@mui/material/FormGroup";
import FormControlLabel from "@mui/material/FormControlLabel";
import Checkbox from "@mui/material/Checkbox";
import FormControl from "@mui/material/FormControl";
import FormHelperText from '@mui/material/FormHelperText';
import _ from "lodash";

type IMyCheckBoxProps = {
  value: Array<any>;
  options: Array<ICheckBoxOption>;
  onChange: any; // 直接返回选中项的数组
  variant?: "standard" | "outlined" | "filled";
  error?: boolean; 
  helperText?: string;
};

type ICheckBoxOption = {
  value: any;
  label?: string;
  disabled?: boolean;
};

export const optionsTransform = (
  arr: Array<any>,
  labelKey: string = "label",
  valueKey: string = "value",
  disabledKey: string = "disabled"
): Array<ICheckBoxOption> => {
  return arr.map((item: any) => {
    return {
      value: item[valueKey],
      label: item[labelKey],
      disabled: item[disabledKey] || false,
    };
  });
};

export default function MyCheckBox(props: IMyCheckBoxProps) {
  const { value, options, onChange, error = false, helperText, variant } = props;

  const getCheckedStatus = (
    checkBoxItemValue: any,
    valueArr: Array<any>
  ): boolean => {
    const result = valueArr.indexOf(checkBoxItemValue);
    return result === -1 ? false : true;
  };

  const handleMyCheckBoxOnChange = (e: any) => {
    const resultArr = _.cloneDeep(value);
    const clickValue = e.target.name;
    const clickValueIndex = value.indexOf(clickValue);
    if (clickValueIndex === -1) {
      resultArr.push(clickValue);
      onChange && onChange(resultArr);
    } else {
      resultArr.splice(clickValueIndex, 1);
      onChange && onChange(resultArr);
    }
  };

  return (
    <FormControl fullWidth variant={variant} error={error}>
    <FormGroup row>
      {options.map((option) => {
        return (
          <FormControlLabel
            key={option.value}
            control={
              <Checkbox
                checked={getCheckedStatus(option.value, value)}
                value={option.value}
              />
            }
            label={option.label}
            name={option.value}
            onChange={handleMyCheckBoxOnChange}
          />
        );
      })}
    </FormGroup>
      {helperText && error && <FormHelperText>{helperText}</FormHelperText>}
    </FormControl>
  );
}
