import TextField from "@mui/material/TextField";

type MyInputProps = {
  value: any;
  inputSx?: any;
  onChange?: any;
  onFocus?: any;
  label?: string;
  variant?: "standard" | "filled" | "outlined";
  id?: string;
  size?: "small" | "medium";
  placeholder?: string;
  fullWidth?: boolean; // 宽度是否和容器一致
  InputProps?: any; // input加前后icon可以用这个
  error?: boolean;
  helperText?: string;
};

const MyInput = (props: MyInputProps) => {
  const {
    inputSx = {},
    value,
    onChange,
    onFocus,
    label,
    id,
    variant,
    size = "small",
    placeholder = "请输入",
    fullWidth = true,
    InputProps,
    error = false,
    helperText,
  } = props;

  return (
    <TextField
      error={error}
      helperText={helperText}
      value={value}
      sx={{ ...inputSx }}
      id={id}
      label={label}
      variant={variant}
      onChange={onChange}
      onFocus={onFocus}
      size={size}
      placeholder={placeholder}
      fullWidth={fullWidth}
      InputProps={{
        ...InputProps,
      }}
    />
  );
};

export default MyInput;
