import * as React from "react";
import Radio from "@mui/material/Radio";
import RadioGroup from "@mui/material/RadioGroup";
import FormControlLabel from "@mui/material/FormControlLabel";
import FormControl from "@mui/material/FormControl";
import FormHelperText from '@mui/material/FormHelperText';

type IMyRadioProps = {
  value: any;
  options: Array<ICheckBoxOption>;
  onChange: any;
  variant?: "standard" | "outlined" | "filled";
  error?: boolean; 
  helperText?: string;
};

type ICheckBoxOption = {
  value: any;
  label?: string;
  disabled?: boolean;
};

// 如果后端给的options不是  value-label的字段可以用下面的方法转换
export const optionsTransform = (
  arr: Array<any>,
  labelKey: string = "label",
  valueKey: string = "value",
  disabledKey: string = "disabled"
): Array<ICheckBoxOption> => {
  return arr.map((item: any) => {
    return {
      value: item[valueKey],
      label: item[labelKey],
      disabled: item[disabledKey] || false,
    };
  });
};

export default function MyRadio(props: IMyRadioProps) {
  const { value, options, onChange , error = false, helperText, variant} = props;

  return (
    <FormControl fullWidth variant={variant} error={error}>
      <RadioGroup
        row
        aria-labelledby="demo-row-radio-buttons-group-label"
        name="row-radio-buttons-group"
        value={value}
        onChange={onChange}
      >
        {options.map((option) => {
          return (
            <FormControlLabel
              key={option.value}
              value={option.value}
              control={<Radio />}
              label={option.label}
            />
          );
        })}
      </RadioGroup>
      {helperText && error && <FormHelperText>{helperText}</FormHelperText>}
    </FormControl>
  );
}
