/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-07 20:31:40
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo } from "react";
import { isEqual } from "lodash";
import { useState, useMemo, useEffect } from "react";
import { Box } from "@mui/system";
import Tab from "@mui/material/Tab";
import { TabContext, TabList, TabPanel } from "@mui/lab";
import { Typography } from "@mui/material";
import { useImperativeHandle } from "react";

interface ITabList {
  label: string;
  value: string;
  component: JSX.Element;
  icon?: string;
  iconed?: string;
  hide?: boolean;
}

interface IProps {
  tabList: ITabList[];
  onRef?: any;
}

const Tabs = (props: IProps) => {
  const { tabList } = props;
  const [value, setValue] = useState(tabList.filter((e) => !e.hide)[0].value);

  const onChange = (val: string) => {
    setValue(val);
  };

  const setActiveTab = (val: string) => {
    onChange(val);
  };

  useImperativeHandle(props.onRef, () => {
    return {
      setActiveTab: setActiveTab,
    };
  });

  const labelRender = (item: ITabList, key: number) => {
    return (
      <Box style={{ display: "flex", alignItems: "center" }}>
        {item.icon ? (
          <img
            style={{ width: "14px", marginRight: "10px" }}
            src={value === item.value ? item.iconed : item.icon}
            alt=""
          />
        ) : (
          ""
        )}
        <Typography sx={{ fontSize: "14px", fontWeight: "400" }}>
          {item.label}
        </Typography>
      </Box>
    );
  };

  return (
    <TabContext value={value}>
      <Box sx={{ borderBottom: 1, borderColor: "#F0F2F5" }}>
        <TabList
          onChange={(e: any, val: string) => {
            onChange(val);
          }}
          aria-label="lab API tabs example"
        >
          {tabList?.map((item, key) => {
            if (item.hide) return "";
            return (
              <Tab
                key={key}
                label={labelRender(item, key)}
                value={item.value}
                id={item.value}
              />
            );
          })}
        </TabList>
      </Box>
      {tabList?.map((item) => {
        return (
          <TabPanel
            sx={{ padding: "20px 0 0 0" }}
            value={item.value}
            key={item.value}
          >
            {item.component}
          </TabPanel>
        );
      })}
    </TabContext>
  );
};
const handleEqual = (prvProps: IProps, nextProps: IProps) => {
  if (isEqual(prvProps, nextProps)) {
    return true;
  }
  return false;
};

export default memo(Tabs, handleEqual);
