/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 20:03:56
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-26 17:24:46
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React, { useEffect, useState } from "react";
import styles from "./index.module.css";
import ConfigForm from "./ConfigForm";
import WorkFlow from "./WorkFlow";
import ButtonComponent from "@/components/mui/Button";
import ArrowBackIosNewIcon from "@mui/icons-material/ArrowBackIosNew";
import IconButton from "@mui/material/IconButton";
import { ITemplateConfig } from "./interface";
import _ from "lodash";
import useMyRequest from "@/hooks/useMyRequest";
import { fetchTemplateConfigInfo, submitWorkFlow } from "@/api/project_api";
import { useLocation, useNavigate } from "react-router-dom";
import { getCheckResult } from "./util";
import { IResponse } from "@/api/http";
import { templateConfigJson } from "./mock";
import { useMessage } from "@/components/MySnackbar";
import { toJS } from "mobx";
import { useStores } from "@/store";
import moment from "moment";
import MyPopconfirm from "@/components/mui/MyPopconfirm";

const ProjectSubmitWork = () => {
  const Message = useMessage();
  const { currentProjectStore } = useStores();
  const projectId = toJS(currentProjectStore.currentProjectInfo.id);
  const [templateConfigInfo, setTemplateConfigInfo] =
    useState<ITemplateConfig>();
  const location: any = useLocation();
  const navigate = useNavigate();
  let configFormRef: any = React.createRef();

  // 前往工作台
  const goToWorkbench = (toWorkbenchList = false) => {
    navigate("/product/cadd/projectWorkbench", {
      state: { from: toWorkbenchList ? "submitWork" : "" },
    });
  };

  // 返回
  const handleGoBack = () => {
    goToWorkbench();
  };

  if (!location?.state?.id) {
    goToWorkbench();
  }

  /** 获取模版数据 */
  const { run } = useMyRequest(fetchTemplateConfigInfo, {
    onSuccess: (res: IResponse<ITemplateConfig>) => {
      // setTemplateConfigInfo(templateConfigJson as ITemplateConfig);
      setTemplateConfigInfo(res.data);
      configFormRef.current.setInitName(res.data.title);
    },
    onError: () => {
      // setTemplateConfigInfo(templateConfigJson as ITemplateConfig);
    },
  });

  const { run: submitWorkFlowRun } = useMyRequest(submitWorkFlow, {
    onSuccess: (res) => {
      Message.success("提交成功");
      goToWorkbench(true);
    },
  });

  useEffect(() => {
    run({
      id: location?.state?.id,
    });
  }, [location?.state?.id, run]);

  const setParameter = (value: any, taskId: string, parameterName: string) => {
    const result: ITemplateConfig = _.cloneDeep(templateConfigInfo);
    result.tasks.forEach((tack) => {
      if (tack.id === taskId) {
        let isCheck = true;
        tack.parameters
          .filter((parameter) => parameter.hidden === false)
          .forEach((parameter) => {
            if (parameter.name === parameterName) {
              parameter.value = value;
              const checkResult = getCheckResult(parameter, value);
              parameter.error = checkResult.error;
              parameter.helperText = checkResult.helperText;
            } else {
              return;
            }
            if (getCheckResult(parameter, value).error === true) {
              isCheck = false;
            }
            tack.isCheck = isCheck;
          });
      } else {
        return;
      }
    });
    setTemplateConfigInfo(result);
  };

  const handleSubmitForm = () => {
    let check = true;
    const { name, outputPath, nameAndOutputPathCheck } =
      configFormRef.current.getNameAndPath();
    if (!nameAndOutputPathCheck) {
      check = false;
    }
    const result: ITemplateConfig = _.cloneDeep(templateConfigInfo);
    result.tasks.forEach((tack) => {
      tack.parameters
        .filter((parameter) => parameter.hidden === false)
        .forEach((parameter) => {
          const checkResult = getCheckResult(parameter, parameter.value);
          parameter.error = checkResult.error;
          parameter.helperText = checkResult.helperText;
          if (checkResult.error) {
            check = false;
          }
        });
    });
    setTemplateConfigInfo(result);
    if (check) {
      let promotedParameters: any = {};
      result.tasks.forEach((tack) => {
        tack.parameters
          .filter((parameter) => parameter.hidden === false)
          .forEach((parameter) => {
            let value: string = "";
            if (Array.isArray(parameter.value)) {
              value = parameter.value.join(",");
            } else {
              value = parameter.value;
            }
            if (
              parameter.domType.toLowerCase() === "path" ||
              parameter.domType.toLowerCase() === "dataset" ||
              parameter.domType.toLowerCase() === "file"
            ) {
              if (value === "ProjectData") {
                value = "/home/cloudam";
              } else {
                value = `/home/cloudam${value.slice(11)}`;
              }
            }
            promotedParameters[parameter.name] = {
              [parameter.classTypeName]: value,
            };
          });
      });
      submitWorkFlowRun({
        name,
        outputPath:
          outputPath === "ProjectData"
            ? "/home/cloudam"
            : `/home/cloudam${outputPath.slice(11)}`,
        projectId: projectId as string,
        specId: templateConfigInfo?.id as string,
        promotedParameters,
      });
    } else {
      Message.error("请完善左侧表单再提交");
    }
  };

  return (
    <div className={styles.swBox}>
      <div className={styles.swHeader}>
        <div className={styles.swHeaderLeft}>
          <MyPopconfirm
            title="返回后，当前页面已填写内容将不保存，确认返回吗？"
            onConfirm={handleGoBack}
          >
            <IconButton
              color="primary"
              // onClick={() => handleGoBack()}
              aria-label="upload picture"
              component="span"
              size="small"
            >
              <ArrowBackIosNewIcon
                sx={{
                  color: "rgba(194, 198, 204, 1)",
                  width: "12px",
                  height: "12px",
                }}
              />
            </IconButton>
          </MyPopconfirm>

          <div className={styles.swTemplateTitle}>
            {templateConfigInfo?.title}
          </div>
          <div className={styles.swTemplateVersionBox}>
            <span className={styles.swHeaderLable}>版本：</span>
            <span className={styles.swHeaderValue}>
              {templateConfigInfo?.version}
            </span>
          </div>
          <div className={styles.swTemplateUpdateTimeBox}>
            <span className={styles.swHeaderLable}>更新时间：</span>
            <span className={styles.swHeaderValue}>
              {templateConfigInfo?.updateTime
                ? moment(templateConfigInfo?.updateTime).format(
                    "YYYY-MM-DD HH:mm:ss"
                  )
                : "-"}
            </span>
          </div>
          <div className={styles.swHeaderGoback}></div>
        </div>
        <div className={styles.swHeaderRight}>
          <MyPopconfirm
            title="提交前请先确认参数填写无误，确认提交吗？"
            onConfirm={handleSubmitForm}
          >
            <ButtonComponent
              text="提交任务"
              // click={handleSubmitForm}
            ></ButtonComponent>
          </MyPopconfirm>
        </div>
      </div>
      <div className={styles.swContent}>
        <div className={styles.swFormBox}>
          <ConfigForm
            onRef={configFormRef}
            templateConfigInfo={templateConfigInfo}
            setParameter={setParameter}
          />
        </div>
        <div className={styles.swFlowBox}>
          <WorkFlow templateConfigInfo={templateConfigInfo} />
        </div>
      </div>
    </div>
  );
};

export default ProjectSubmitWork;
