import { IParameter } from "./interface"
export const getCheckResult = (parameter: IParameter, value: string): {
    error: boolean,
    helperText: string
} => {
    let error = false
    let helperText = ''
    // 表单校验
    if (parameter.required) {
        if (Array.isArray(value)) {
            if (value.length === 0) {
                error = true
                helperText = '该选项是必填项'
            }
        } else if (value === '' || value === null || value === undefined) {
            error = true
            helperText = '该选项是必填项'
        }
    }
    if (parameter.validators.length > 0) {
        parameter.validators.forEach((validator)=>{
            const reg = new RegExp(validator.regex)
            if (!reg.test(value)) {
                error = true
                helperText = validator.message
            }
        })
    }
    return {
        error,
        helperText
    }
}