/*
 * @Author: rocosen
 * @Date: 2022-06-12 10:05:13
 * @LastEditors: rocosen
 * @LastEditTime: 2022-06-07 20:23:02
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React, { memo, useState, useMemo, useEffect } from "react";

import { Box } from "@mui/system";
import { useStores } from "@/store/index";
import NoProject from "@/components/NoProject";
import { observer } from "mobx-react-lite";
import projectImg from "@/assets/project/projectIconSmall.svg";
import WorkbenchTemplate from "./workbenchTemplate";
import WorkbenchList from "./workbenchList";
import Tabs from "@/components/mui/Tabs";
import usePass from "@/hooks/usePass";
import { useLocation } from "react-router-dom";

import Template from "@/assets/project/workbenchTemplate.svg";
import Template_select from "@/assets/project/workbenchTemplate_select.svg";
import List from "@/assets/project/workbenchList.svg";
import List_select from "@/assets/project/workbenchList_select.svg";

//ui
// import ButtonDemo from "@/views/mui_demo/button";
// import InputDemo from "@/views/mui_demo/input";

const ProjectWorkbench = observer(() => {
  const { currentProjectStore } = useStores();
  const isPass = usePass();
  const location = useLocation();

  let tabsRef: any = React.createRef();

  useEffect(() => {
    console.log(isPass("PROJECT_WORKBENCH_FLOES_USE", "USER"), "11111111111");
    console.log(isPass("PROJECT_WORKBENCH_FLOES"), "wwwwwwwwwww");
  }, []);

  useEffect(() => {
    const locationInfo: any = location?.state;
    const from = locationInfo?.from;
    // 如果是从详情页来的，tab展示为任务列表
    if (from === "detail" || from === "submitWork") {
      tabsRef?.current?.setActiveTab("workbenchList");
    }
  }, [location, tabsRef]);

  const tabList = useMemo(() => {
    return [
      {
        label: "工作流模版",
        value: "workbenchTemplate",
        component: <WorkbenchTemplate />,
        hide: !isPass("PROJECT_WORKBENCH_FLOES"),
        icon: Template,
        iconed: Template_select,
      },
      {
        label: "任务列表",
        value: "workbenchList",
        component: <WorkbenchList />,
        hide: !isPass("PROJECT_WORKBENCH_JOBS"),
        icon: List,
        iconed: List_select,
      },
      //   {
      //     label: "按钮组件",
      //     value: "MUI_BUTTON",
      //     component: <ButtonDemo />,
      //     icon: List,
      //     iconed: List_select,
      //   },
      //   {
      //     label: "输入框组件",
      //     value: "MUI_INPUT",
      //     component: <InputDemo />,
      //     icon: List,
      //     iconed: List_select,
      //   },
    ];
  }, []);

  return (
    <div style={{ padding: 24 }}>
      <div style={{ display: "flex", alignItems: "center" }}>
        <img src={projectImg} alt="项目logo" />
        <span style={{ marginLeft: 12 }}>工作台</span>
      </div>
      <Box sx={{ width: "100%", typography: "body1" }}>
        <Tabs onRef={tabsRef} tabList={tabList} />
      </Box>
    </div>
  );
});

export default memo(ProjectWorkbench);
