import {
  Box,
  List,
  ListItem,
  ListItemText,
  ListItemButton,
} from "@mui/material";
import React from "react";
import { Outlet, useNavigate } from "react-router-dom";
import style from "./index.module.css";
import { observer } from "mobx-react-lite";
import { useStores } from "@/store/index";

const MenuLayout = observer(() => {
  const { permissionStore } = useStores();

  const navigate = useNavigate();

  return (
    <Box className={style.container}>
      <Box sx={{ width: "10%" }}>
        <List>
          {permissionStore.sidebarRouters.map((item, index) => {
            return (
              <ListItem key={"sidebar" + index}>
                <ListItemButton
                  onClick={() => item.type === "page" && navigate(item.path)}
                >
                  <ListItemText>{item.name}</ListItemText>
                </ListItemButton>
              </ListItem>
            );
          })}
        </List>
      </Box>
      <Box sx={{ width: "90%" }}>
        <Outlet></Outlet>
      </Box>
    </Box>
  );
});

export default MenuLayout;
