import React, { memo, useCallback, useEffect } from "react";
import ReactFlow, {
  addEdge,
  Background,
  useNodesState,
  useEdgesState,
} from "react-flow-renderer";
import { Edge, Node, Connection } from "react-flow-renderer";
import MyFlowNode from "./MyFlowNode";

type inputProp = {
  initialNodes: Array<Node>;
  initialEdges: Array<Edge>;
  edit?: boolean;
  onClick?: (id: string) => void;
};

const nodeTypes = {
  custom: MyFlowNode,
};

const OverviewFlow = memo(
  ({ initialNodes, initialEdges, edit = false, onClick }: inputProp) => {
    const [nodes, setNodes, onNodesChange] = useNodesState([]);
    const [edges, setEdges, onEdgesChange] = useEdgesState([]);
    const onConnect = (params: Edge<any> | Connection) =>
      setEdges((eds) => addEdge(params, eds));

    useEffect(() => {
      if (initialEdges.length && initialNodes.length) {
        setNodes(initialNodes);
        setEdges(initialEdges);
      }
    }, [initialEdges, initialNodes, setEdges, setNodes]);

    const onClickCapture = useCallback((event: any) => {
      onClick && onClick(event.target.children[0]?.dataset.nodeid);
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);

    return (
      <ReactFlow
        nodes={nodes}
        edges={edges}
        onNodesChange={edit ? onNodesChange : undefined}
        onEdgesChange={edit ? onEdgesChange : undefined}
        onConnect={edit ? onConnect : undefined}
        fitView
        onClick={onClickCapture}
        style={{ backgroundColor: "#F7F8FA" }}
        nodeTypes={nodeTypes}
      >
        <Background color="#C2C6CC" gap={16} size={0.5} />
      </ReactFlow>
    );
  }
);

export default OverviewFlow;
