import { Box } from "@mui/system";
import { Edge, Handle, Position } from "react-flow-renderer";
import styles from "./nodeStyles.module.css";

type parameter = {
  id: string;
  name: string;
  class: string;
  type: string;
  hidden: false;
  required: boolean;
  value: string;
  description: string;
  level: string;
  many: boolean;
  null: boolean;
  promoted: boolean;
  promoted_name: string;
  title: string;
  validators: string;
  choices: object;
};

type handle = {
  id: string;
  name: string;
  class:
    | "DatasetInputParameter"
    | "DatasetOutputParameter"
    | "FileInputParameter"
    | "FileOutputParameter";
  type: "DATASET" | "FILE" | "ARRAY[FILE]" | "ARRAY[DATASET]";
  hidden: true;
};

const MyFlowNode = ({
  data,
}: {
  data: {
    title: string;
    description: string;
    status: "success" | "default";
    selected: boolean;
    parameters: Array<parameter | handle>;
    edges: Array<Edge>;
  };
}) => {
  let targetIndex = -1;
  let sourceIndex = -1;
  return (
    <Box
      sx={{
        width: "130px",
        display: "flex",
        borderRadius: "4px",
        fontSize: "12px",
        fontWeight: "500",
        color: "#1e2633",
        lineHeight: "20px",
        backgroundColor: "#ffffff",
        border: data.selected ? "1px solid #1370ff" : "1px solid #e6e8eb",
        boxShadow: data.selected
          ? "0px 3px 10px 0px rgba(0, 24, 57, 0.14)"
          : "",
      }}
    >
      {data.parameters.map((item) => {
        if (
          item.hidden === true &&
          (item.class === "DatasetInputParameter" ||
            item.class === "FileInputParameter")
        ) {
          targetIndex++;
          return (
            <Handle
              key={item.id}
              type="target"
              position={Position.Top}
              id={item.id}
              style={{ left: targetIndex * 16 + 16 }}
            />
          );
        } else {
          return null;
        }
      })}
      {data.parameters.map((item, index) => {
        if (
          item.hidden === true &&
          (item.class === "DatasetOutputParameter" ||
            item.class === "FileOutputParameter")
        ) {
          sourceIndex++;
          return (
            <Handle
              key={item.id}
              type="source"
              position={Position.Bottom}
              id={item.id}
              style={{ left: sourceIndex * 16 + 16 }}
            />
          );
        } else {
          return null;
        }
      })}
      <Box
        className={data.status === "success" ? styles.success : styles.default}
      ></Box>
      <Box>{data.title}</Box>
    </Box>
  );
};

export default MyFlowNode;
