import { Node } from "react-flow-renderer";

export const demoData: templateData = {
  id: "370a0fb4-89cf-411c-8142-c8d0756a4f78",
  title: "CADD EXAMPLE",
  version: "1.0.0",
  description: "",
  language: "WDL",
  languageVersion: "1.0",
  tags: [],
  source: "BASE64_ENCODED_WDL/CWL",
  floes: [
    {
      id: "taskA",
      position: {
        x: 0,
        y: 0,
      },
      data: {
        title: "输入分子",
        description: "",
        parameters: [
          {
            id: "taskA-1",
            name: "unit_input_dataset",
            class: "DatasetInputParameter",
            type: "DATASET",
            hidden: false,
            required: true,
            value: "",
            description: "Dataset with the design unit (DU) to dock to.",
            level: "USER",
            many: false,
            null: false,
            promoted: true,
            promotedName: "unit_input_dataset",
            title: "Design Unit or Receptor Dataset(s)",
            validators: "",
            choices: {},
          },
          {
            id: "taskA-2",
            name: "分子库A",
            class: "DatasetOutputParameter",
            type: "DATASET",
            value: "out",
            hidden: true,
          },
        ],
        edges: [
          {
            id: "taskA-taskB",
            source: "taskA",
            sourceHandle: "taskA-2",
            target: "taskB",
            targetHandle: "taskB-1",
            label: "taskA.out",
          },
          {
            id: "taskA-taskC",
            source: "taskA",
            sourceHandle: "taskA-2",
            target: "taskC",
            targetHandle: "taskC-1",
            label: "taskA.out",
          },
        ],
      },
    },
    {
      id: "taskB",
      position: {
        x: 0,
        y: 100,
      },
      data: {
        title: "基础属性筛选",
        description: "",
        parameters: [
          {
            id: "taskB-1",
            name: "接收分子库",
            class: "DatasetInputParameter",
            type: "DATASET",
            value: "taskA.out",
            hidden: true,
          },
          {
            id: "taskB-2",
            name: "基础属性1",
            class: "StringParameter",
            type: "String",
            hidden: false,
            required: true,
            value: "",
            description: "Dataset with the design unit (DU) to dock to.",
            level: "USER",
            many: false,
            null: false,
            promoted: true,
            promoted_name: "unit_input_dataset",
            title: "Design Unit or Receptor Dataset(s)",
            order: 1,
            validators: "",
            choices: {},
          },
          {
            id: "taskB-3",
            name: "基础属性2",
            class: "StringParameter",
            type: "String",
            required: true,
            hidden: false,
            value: "",
            description: "Dataset with the design unit (DU) to dock to.",
            level: "USER",
            many: false,
            null: false,
            promoted: true,
            promoted_name: "unit_input_dataset",
            title: "Design Unit or Receptor Dataset(s)",
            order: 2,
            validators: "",
            choices: {},
          },
          {
            id: "taskB-4",
            name: "基础属性3",
            class: "StringParameter",
            type: "String",
            hidden: false,
            required: true,
            value: "",
            description: "Dataset with the design unit (DU) to dock to.",
            level: "USER",
            many: false,
            null: false,
            promoted: true,
            promoted_name: "unit_input_dataset",
            title: "Design Unit or Receptor Dataset(s)",
            order: 1,
            validators: "",
            choices: {},
          },
          {
            id: "taskB-5",
            name: "输出分子库",
            class: "DatasetOutputParameter",
            type: "DATASET",
            value: "out",
            hidden: true,
          },
        ],
        edges: [
          {
            id: "taskB-taskD",
            source: "taskB",
            sourceHandle: "taskB-5",
            target: "taskD",
            targetHandle: "taskD-1",
            label: "taskB.out",
          },
        ],
      },
    },
    {
      id: "taskC",
      position: {
        x: 250,
        y: 100,
      },
      data: {
        title: "采样器",
        description: "",
        parameters: [
          {
            id: "taskC-1",
            name: "接收分子库",
            class: "DatasetInputParameter",
            type: "DATASET",
            value: "taskA.out",
            hidden: true,
          },
          {
            id: "taskC-2",
            name: "基础属性3",
            class: "StringParameter",
            type: "String",
            hidden: false,
            required: true,
            value: "",
            description: "Dataset with the design unit (DU) to dock to.",
            level: "USER",
            many: false,
            null: false,
            promoted: true,
            promoted_name: "unit_input_dataset",
            title: "Design Unit or Receptor Dataset(s)",
            order: 1,
            validators: "",
            choices: {},
          },
          {
            id: "taskC-3",
            name: "输出分子库",
            class: "DatasetOutputParameter",
            type: "DATASET",
            value: "out",
            hidden: true,
          },
        ],
        edges: [
          {
            id: "taskC-taskD",
            source: "taskC",
            sourceHandle: "taskC-3",
            target: "taskD",
            targetHandle: "taskD-2",
            label: "taskC.out",
          },
        ],
      },
    },
    {
      id: "taskD",
      position: {
        x: 0,
        y: 200,
      },
      data: {
        title: "输出结果",
        description: "",
        parameters: [
          {
            id: "taskD-1",
            name: "接收分子库",
            class: "DatasetInputParameter",
            type: "DATASET",
            value: "taskB.out",
            hidden: true,
          },
          {
            id: "taskD-2",
            name: "接收分子库",
            class: "DatasetInputParameter",
            type: "DATASET",
            value: "taskC.out",
            hidden: true,
          },
          {
            id: "taskD-3",
            name: "结果名称",
            class: "StringParameter",
            type: "String",
            hidden: false,
            required: true,
            value: "",
            description: "",
            level: "USER",
            many: false,
            null: false,
            promoted: true,
            promoted_name: "",
            title: "",
            order: 1,
            validators: "",
            choices: {},
          },
        ],
      },
    },
  ],
};

export type templateData = {
  id: string;
  title: string;
  version: string;
  description: string;
  language: string;
  languageVersion: string;
  tags: string[];
  source: string;
  floes: Array<Node>;
};
