import { Box } from "@mui/system";
import { demoData } from "./demoData";
import MyFlow from "./components/MyFlow";
import { useImmer } from "use-immer";
import { useCallback, useEffect } from "react";
import { Node, Edge } from "react-flow-renderer";

const Demo = () => {
  const [initialNodes, setInitialNodes] = useImmer<Array<Node>>([]);
  const [initialEdges, setInitialEdges] = useImmer<Array<Edge>>([]);

  useEffect(() => {
    let edges: Array<Edge> = [];
    for (let floe of demoData.floes) {
      if (floe.data.edges) {
        for (let item of floe.data.edges) {
          item.type = "smoothstep";
          item.style = {
            stroke: "#D1D6DE",
          };
          item.labelBgStyle = {
            fill: "#F7F8FA",
          };
        }
        edges.push(...floe.data.edges);
      }
      floe.type = "custom";
      floe.data.status = "default";
      floe.data.selected = false;
    }
    setInitialNodes(demoData.floes);
    setInitialEdges(edges);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  //   const onFormItemFocus = useCallback((id: string) => {
  //     setInitialNodes((initialNodes) => {
  //       for (let node of initialNodes) {
  //         node.data.selected = node.id === id;
  //       }
  //     });
  //     setInitialEdges((initialEdges) => {
  //       for (let edge of initialEdges) {
  //         edge.animated = false;
  //         if (edge.target === id) {
  //           edge.animated = true;
  //         }
  //         if (edge.source === id) {
  //           edge.animated = true;
  //         }
  //       }
  //     });
  //     // eslint-disable-next-line react-hooks/exhaustive-deps
  //   }, []);

  const onFormItemSuccess = useCallback((id: string) => {
    setInitialNodes((initialNodes) => {
      for (let node of initialNodes) {
        if (node.id === id) {
          if (node.data.status === "success") {
            node.data.status = "default";
          } else {
            node.data.status = "success";
          }
        }
      }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  const onFlowClick = useCallback((id: string) => {
    setInitialNodes((initialNodes) => {
      for (let node of initialNodes) {
        node.data.selected = node.id === id;
      }
    });
    setInitialEdges((initialEdges) => {
      for (let edge of initialEdges) {
        edge.animated = false;
        edge.style = {
          stroke: "#D1D6DE",
        };
        if (edge.target === id) {
          edge.animated = true;
          edge.style = {
            stroke: "#1370FF",
          };
        }
        if (edge.source === id) {
          edge.animated = true;
          edge.style = {
            stroke: "#1370FF",
          };
        }
      }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  return (
    <Box sx={{ display: "flex", width: "100%", height: "650px" }}>
      <Box sx={{ width: "50%" }}>
        {initialNodes.map((node) => {
          return (
            <Box
              key={node.id}
              sx={{
                padding: "7px 30px",
                backgroundColor: node.data.selected ? "#D9E8FF" : "#F1F1F1",
                fontSize: "14px",
                margin: "20px 0px",
                cursor: "pointer",
              }}
              onClick={() => {
                // onFormItemFocus(node.id);
                onFormItemSuccess(node.id);
              }}
            >
              {node.data.title}
            </Box>
          );
        })}
      </Box>
      <Box sx={{ width: "50%" }}>
        <MyFlow
          initialEdges={initialEdges}
          initialNodes={initialNodes}
          edit={false}
          onClick={onFlowClick}
        ></MyFlow>
      </Box>
    </Box>
  );
};

export default Demo;
