#ifndef __CR_ASM_GENERIC_STRING_H__
#define __CR_ASM_GENERIC_STRING_H__

#include "compiler.h"

#ifndef HAS_BUILTIN_MEMCPY
static always_inline void *builtin_memcpy(void *to, const void *from, unsigned int n)
{
	int i;
	unsigned char *cto = to;
	const unsigned char *cfrom = from;

	for (i = 0; i < n; ++i, ++cto, ++cfrom) {
		*cto = *cfrom;
	}

	return to;
}
#endif

#endif /* __CR_ASM_GENERIC_STRING_H__ */
