#!/bin/sh

name_ifndef=$1
name_prefix_offset=$2
name_blob=$3
name_objname=$4
name_bin=$5

awk_cmd="{ print \"#define $name_prefix_offset\" \$3 \" 0x\" \$1; }"

echo "/* Autogenerated file, don't edit */"
echo "#ifndef $name_ifndef"
echo "#define $name_ifndef"
echo ""
nm $name_objname | grep ' [Tt] ' | sed -e 's/\./_/g' | awk "$awk_cmd"
echo ""
echo "static char $name_blob[] = {"
hexdump -v -e '"\t"' -e '8/1 "0x%02x, "' -e '"\n"' $name_bin
echo "};"
echo ""
echo "#endif /* $name_ifndef */"

