#ifndef __CR_SOCKETS_H__
#define __CR_SOCKETS_H__

#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdbool.h>

#include "asm/types.h"

#include "protobuf.h"
#include "protobuf/sk-opts.pb-c.h"

struct fdinfo_list_entry;
struct sk_opts_entry;
struct file_desc;
struct fd_parms;
struct cr_fdset;
struct nlmsghdr;

struct socket_desc {
	unsigned int		family;
	unsigned int		ino;
	struct socket_desc	*next;
	int			already_dumped;
};

extern int dump_socket(struct fd_parms *p, int lfd, const int fdinfo);
extern int dump_socket_opts(int sk, SkOptsEntry *soe);
extern int restore_socket_opts(int sk, SkOptsEntry *soe);
extern void release_skopts(SkOptsEntry *);
extern int restore_prepare_socket(int sk);

extern bool socket_test_collect_bit(unsigned int family, unsigned int proto);

extern int sk_collect_one(int ino, int family, struct socket_desc *d);
extern int collect_sockets(int pid);
extern int collect_inet_sockets(void);
extern struct collect_image_info unix_sk_cinfo;
extern int collect_unix_sockets(void);
extern int fix_external_unix_sockets(void);
extern int resolve_unix_peers(void);

extern struct collect_image_info netlink_sk_cinfo;

extern void show_unixsk(int fd);
extern void show_inetsk(int fd);
extern void show_sk_queues(int fd);
extern void show_netlinksk(int fd);

extern char *skfamily2s(u32 f);
extern char *sktype2s(u32 t);
extern char *skproto2s(u32 p);
extern char *skstate2s(u32 state);

extern struct socket_desc *lookup_socket(int ino, int family, int proto);

extern const struct fdtype_ops unix_dump_ops;
extern const struct fdtype_ops inet_dump_ops;
extern const struct fdtype_ops inet6_dump_ops;
extern const struct fdtype_ops netlink_dump_ops;
extern const struct fdtype_ops packet_dump_ops;

extern int inet_collect_one(struct nlmsghdr *h, int family, int type);
extern int unix_receive_one(struct nlmsghdr *h, void *);
extern int netlink_receive_one(struct nlmsghdr *hdr, void *arg);

extern int do_dump_opt(int sk, int level, int name, void *val, int len);
#define dump_opt(s, l, n, f)	do_dump_opt(s, l, n, f, sizeof(*f))
extern int do_restore_opt(int sk, int level, int name, void *val, int len);
#define restore_opt(s, l, n, f)	do_restore_opt(s, l, n, f, sizeof(*f))

#define sk_encode_shutdown(img, mask) do {			\
		/* 						\
		 * protobuf SK_SHUTDOWN__ bits match those	\
		 * reported by kernel				\
		 */ 						\
		(img)->shutdown = mask;				\
		if ((img)->shutdown != SK_SHUTDOWN__NONE)	\
			(img)->has_shutdown = true;		\
	} while (0)

static inline int sk_decode_shutdown(int val)
{
	static const int hows[] = {-1, SHUT_RD, SHUT_WR, SHUT_RDWR};
	return hows[val];
}

#define USK_EXT_PARAM "ext-unix-sk"

#endif /* __CR_SOCKETS_H__ */
