#!/bin/sh

NAME=$1
INC_GUARD=__${NAME}_h__
PREFIX=${NAME}_blob_offset__
BLOB=${NAME}_blob
OBJNAME=${NAME}.o
BINARY=${NAME}.bin

AWK_CMD='$2 ~ /^[tT]$/ { print "#define '$PREFIX'" $3 " 0x" $1; }'

cat << EOF
/* Autogenerated by $0, do not edit */
#ifndef $INC_GUARD
#define $INC_GUARD

EOF

nm $OBJNAME | tr . _ | awk "$AWK_CMD"

cat << EOF

static char $BLOB[] = {
EOF

hexdump -v -e '"\t" 8/1 "0x%02x, " "\n"' $BINARY

cat << EOF
};

#endif /* $INC_GUARD */
EOF
