#ifndef PROTOBUF_H__
#define PROTOBUF_H__

#include "types.h"
#include "compiler.h"
#include "util.h"

/*
 * ATTENTION
 *
 * This typdefs represent "generic" prototypes for
 * pack/unpack/getsize functions generated by PB
 * engine, thus (!!!) if PB engine change arguments
 * order or their number we may meet serious problems.
 *
 * FIXME
 *
 * Find a way to verify PB generated functions statemens
 * to match this typedefs.
 */

typedef size_t (pb_getpksize_t)(void *obj);
typedef size_t (pb_pack_t)(void *obj, void *where);
typedef void *(pb_unpack_t)(void *allocator, size_t size, void *from);

extern int pb_read_object_with_header(int fd, void **pobj,
				      pb_unpack_t *unpack,
				      bool eof);

#define pb_read(__fd, __obj_pptr, __proto_message_name)					\
	pb_read_object_with_header(__fd, (void **)__obj_pptr,				\
				   (void *)&__proto_message_name ##__unpack,		\
				   false)

#define pb_read_eof(__fd, __obj_pptr, __proto_message_name)				\
	pb_read_object_with_header(__fd, (void **)__obj_pptr,				\
				   (void *)&__proto_message_name ##__unpack,		\
				   true)

extern int pb_write_object_with_header(int fd, void *obj,
				       pb_getpksize_t *getpksize,
				       pb_pack_t *pack);

#define pb_write(__fd, __obj, __proto_message_name)					\
	pb_write_object_with_header(__fd, __obj,					\
				    (void *)&__proto_message_name ##__get_packed_size,	\
				    (void *)&__proto_message_name ##__pack)

#define pb_pksize(__obj, __proto_message_name)						\
	(__proto_message_name ##__get_packed_size(__obj) + sizeof(u32))

#define pb_repeated_size(__obj, __member)						\
	(sizeof(*(__obj)->__member) * (__obj)->n_ ##__member)

#endif /* PROTOBUF_H__ */
