#!/bin/bash

function fail {
	echo "$@"
	exit 1
}
set -x

CRTOOLS="../../crtools"
IMGDIR="dump/"

rm -rf "$IMGDIR"
mkdir "$IMGDIR"

function launch_test {
	echo "Launching test"
	cd ../zdtm/live/static/
	make cleanout
	make maps04
	make maps04.pid || fail "Can't start test"
	PID=$(cat maps04.pid)
	kill -0 $PID || fail "Test didn't start"
	cd -
}

function stop_test {
	wtime=1
	cd ../zdtm/live/static/
	make maps04.out
	while [ ! -f maps04.out ]; do echo "Wait for maps04.out"; sleep $wtime; ((wtime++)); done
	cat maps04.out | fgrep PASS || fail "Test failed"
	echo "OK"
}

launch_test

echo "Taking plain dump"

mkdir "$IMGDIR/dump-1/"
${CRTOOLS} dump -D "$IMGDIR/dump-1/" -o dump.log -t ${PID} -v 4 || fail "Fail to dump"

sleep 1
echo "Restore to check it works"
${CRTOOLS} restore -D "${IMGDIR}/dump-1/" -o restore.log -d -v 4 || fail "Fail to restore server"

stop_test


launch_test

echo "Taking pre and plain dumps"

echo "Pre-dump"
mkdir "$IMGDIR/dump-2/"
mkdir "$IMGDIR/dump-2/pre/"
${CRTOOLS} pre-dump -D "$IMGDIR/dump-2/pre/" -o dump.log -t ${PID} -v 4 || fail "Fail to pre-dump"

echo "Plain dump"
mkdir "$IMGDIR/dump-2/plain/"
${CRTOOLS} dump -D "$IMGDIR/dump-2/plain/" -o dump.log -t ${PID} -v 4 --prev-images-dir=../pre/ || fail "Fail to dump"

sleep 1
echo "Restore"
${CRTOOLS} restore -D "${IMGDIR}/dump-2/plain/" -o restore.log -d -v 4 || fail "Fail to restore server"

stop_test
